% =========================================================================
%   Praktikum MATLAB/Simulink I
%   Technische Universitt Darmstadt
%   IAT, FG rtm (Prof. Dr.-Ing. U. Konigorski)
%
%   Copyright (c) 2017, FG Regelungstechnik und Mechatronik,
%                       Technische Universitt Darmstadt
%   All rights reserved.
%
%   Redistribution and use in source and binary forms, with or withou
%   modification, are permitted provided that the following conditions are
%   met:
%
%   1. Redistributions of source code must retain the above copyright
%      notice, this list of conditions and the following disclaimer.
%
%   2. Redistributions in binary form must reproduce the above copyright
%      notice, this list of conditions and the following disclaimer in the
%      documentation and/or other materials provided with the distribution.
%
%
%   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
%   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
%   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
%   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
%   HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
%   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
%   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
%   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
%   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
%   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
%   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

% =========================================================================

% Versuch 6
clc
clear all


%% Das SISOTool in Matlab
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%% Versuchsdurchfhrung 6.1.1 %%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

sys = tf(1, [1 1 0 0]);
sisotool(sys)

%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%% Versuchsdurchfhrung 6.1.4 %%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

regler = tf([1 0.25], [1 0.5]);
sisotool(sys, regler)



%% Analyse des Pendelschraubers mit Hilfe der WOK
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%% Versuchsdurchfhrung 6.2.1 %%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% bertragungsfunktion des Pendelschraubers
sys = tf(2.24e-5, [1.72e-9, 5.33e-5, 1.11e-4, 3.533e-5, 0]);

% eigentliche WOK
sisotool(sys)

% komplementre WOK
sisotool(-sys)

%% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%% Versuchsdurchfhrung 6.2.2 %%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Regelung des Pendelschraubers mit dem PID-Regler aus Versuch 4

regler = zpk([-0.3913 -0.1696], 0, 1);
sisotool(sys, regler)

% Versuchsteile 3-6 mssen im Sisotool durchgefhrt werden
%% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%% Versuchsdurchfhrung 6.2.7 %%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% alpha_s=0.25pi
sys2 = tf(1.89e-5, [1.72e-9, 5.33e-5, 1.08e-4, 2.29e-5, -1.87e-5]);

% alpha_s=-9.25pi
sys3 = tf(1.89e-5, [1.72e-9, 5.33e-5, 1.09e-4, 4.57e-5, 1.87e-5]);

k = 3.53;
figure('name', 'Sprungantwort')
step(feedback(k * sys * regler, 1))
axis([0 30 0 1.4])
grid on
figure('name', 'Sprungantwort bei fr alpha = 0,25pi')
step(feedback(k * sys2 * regler, 1))
axis([0 70 0 2])
grid on
figure('name', 'Sprungantwort bei fr alpha = 0,25pi')
step(feedback(k * sys3 * regler, 1))
axis([0 50 0 1])
grid on

%% Analyse von Parameternderungen mit Hilfe der WOK
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%% Versuchsdurchfhrung 6.3.1 %%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Parameter

%Regler
k_max = 3.53;

% WOK
N = 2 * gamma * w_s * HR * cM * k_max * regler ...
                + tf([JW cW 0], 1) * tf([L*JP, R*JP + K*L, K*R + cM^2], 1);
Z = -k * tf([L*JP, R*JP + K*L, K*R + cM^2], 1);
G = Z / N;

% Plot
figure('name', 'Wurzelortskurve in Abhngigkeit von alpha')
rlocus(G);
title('Eigentliche WOK');
axis([-3 3 -3 3])
figure('name', 'Uneigentliche Wurzelortskurve in Abhngigkeit von alpha')
rlocus(-G)
title('Uneigentliche WOK');
axis([-3 3 -5 5])
