%% Analog input
%   
%  Copyright (C) 2010 DataTranslation Inc.
%

%% Introduction
% This example demonstrates how to perform anlaog input measurements.


%%
% Open connection to instrument.
% devRsrcName is an IVI logical name or an instrument specific string that 
% identifies the address of the instrument, such as a VISA resource descriptor
% string.
devRsrcName = 'TCPIP::192.43.218.135::SOCKET';

% Create device object
deviceObj = icdevice('DT8824_DT8824', devRsrcName);

try
    %% Connect device object to the DT8824 instrument
    connect(deviceObj);
    
    %% Get instrument identity
    
    comobj = get(deviceObj, 'Identity');
    propertyValue = get(comobj, 'InstrumentModel');
    str = strcat ('InstrumentModel= ',propertyValue);  
    disp(str);
    propertyValue = get(comobj, 'InstrumentManufacturer');
    str = strcat ('InstrumentManufacturer= ',propertyValue);  
    disp(str);
    propertyValue = get(comobj, 'InstrumentFirmwareRevision');
    str = strcat ('InstrumentFirmwareRevision= ',propertyValue);  
    disp(str);
    propertyValue = get(comobj, 'Description');
    str = strcat ('Description= ',propertyValue);  
    disp(str);
    propertyValue = get(comobj, 'Identifier');
    str = strcat ('Identifier= ',propertyValue);  
    disp(str);
    propertyValue = get(comobj, 'Vendor');
    str = strcat ('Vendor= ',propertyValue);  
    disp(str);
    propertyValue = get(comobj, 'Revision');
    str = strcat ('Revision= ',propertyValue);  
    disp(str);
    
    %% Display the AnalogInputChannels collection
    analogInputChannelCount = deviceObj.Analoginputchannels.Count;
    
    % Preallocate array.
    analogInputChannelNames={analogInputChannelCount};

    for iLoop= 1:analogInputChannelCount
        analogInputChannelNames{iLoop, 1} = invoke(deviceObj.Analoginputchannels, 'Name', iLoop);
    end
    disp(analogInputChannelNames)
    
    %% Enable the channels to be measured by the DT8824 instrument
    
    groupObj = get(deviceObj, 'Analoginputchannels');
    groupObj = groupObj(1);
    
    % Enable analog input channel 1 measurment
    AiChanObject = invoke(groupObj, 'Item', 'AD.1');
    AiChanObject.Enabled = true;
    
    % Enable analog input channel 2 measurment
    groupObj = get(deviceObj, 'Analoginputchannels');
    groupObj = groupObj(1);
    Ctr1Object = invoke(groupObj, 'Item', 'AD.2');
    Ctr1Object.Enabled = true;
    
    % Enable analog input channel 3 measurment
    TachObject = invoke(groupObj, 'Item', 'AD.3');
    TachObject.Enabled = true;
    
    %% Configure the analog input subsystem
    
    GroupObj = get(deviceObj, 'Analoginputacquisition');
    analogInputAcquisitionObj = GroupObj(1);
    
    % Disable wrapping, so that data does not get overwritten in the
    % hardware FIFO when the FIFO is full
    set(analogInputAcquisitionObj, 'WrapEnabled', 'off');
  
    % Set the clock frequency
    set(deviceObj.Analoginputacquisition(1), 'SampleRate', 1000);
    
    % Set the trigger source to trigger the instrument immediately 
    set(deviceObj.Analoginputtrigger(1), 'Source', 'IMMEdiate');
    
    %% Initiate the measurement and get the data. 
    invoke(analogInputAcquisitionObj, 'Arm');
    invoke(analogInputAcquisitionObj, 'Initiate');
    
   
    isRunning = false;
    ScanIndex = 0;
    RequestedScansToRead = 100;
    
    % Wait for the analog input subsystem to change state to Running and
    % the requested number of scans are read
    while (isRunning == false || ScanIndex < (RequestedScansToRead-1))
    [ScanIndex, isRunning, isArmed, isTriggered, isADSyncDetected, isADFifoOverflow] = invoke(analogInputAcquisitionObj, 'GetStatus', 0, 0, 0, 0, 0, 0);
    end
    
    % Read 100 scans from the instrument
    RequestedScansIndex = 0;
    [ActualScansIndex, ActualScansRead, StartTimeInSeconds, StartTimeInMilliSeconds, samples] = invoke(analogInputAcquisitionObj, 'Fetch', int32(RequestedScansIndex), int32(RequestedScansToRead), int32(0), int32(0), int32(0), int32(0), [0;0]);
    
    RequestedScansIndex = ActualScansIndex+ActualScansRead;
    disp(['Actual Scans Index: ', num2str(ActualScansIndex) ,'  Actual Scans Read: ', num2str(ActualScansRead)]);
    
    % reshape the samples into 3 rows (each row is associated with the
    % channel where the first row is associated with analog input channel 1,
    % the second row is associated with the tachometer channel and the
    % third row is assocated with counter 1 channel
    B = reshape(samples,[3 100]);
    
    % display the data for each channel
    disp(B(1,:))
    disp(B(2,:))
    disp(B(3,:))
    
    %% Stop the acquisition
    invoke(analogInputAcquisitionObj, 'Abort');
    
 
catch DT8824error
    disp(['Error id: ', DT8824error.identifier]);
    disp(['Error Message: ',DT8824error.message]);
end

% Disconnect the device object from the instrument and remove it from memory
disconnect(deviceObj);
delete(deviceObj);   

