%% Digital Output Example
%   
%  Copyright (C) 2010 DataTranslation Inc.
%

%% Introduction
% This example demonstrates how to write a value to the digital output port
% and verify the value written by reading back the value from the same port.


%% Open connection to instrument
% devRsrcName is an IVI logical name or an instrument specific string that 
% identifies the address of the instrument, such as a VISA resource descriptor
% string.
devRsrcName = 'TCPIP::192.43.218.135::SOCKET';

% Create device object
deviceObj = icdevice('DT8824_DT8824', devRsrcName);

try
    %% Connect device object to the DT8824 instrument
    connect(deviceObj);
    
    %% Get instrument identity
    
    comobj = get(deviceObj, 'Identity');
    propertyValue = get(comobj, 'InstrumentModel');
    str = strcat ('InstrumentModel= ',propertyValue);  
    disp(str);
    propertyValue = get(comobj, 'InstrumentManufacturer');
    str = strcat ('InstrumentManufacturer= ',propertyValue);  
    disp(str);
    propertyValue = get(comobj, 'InstrumentFirmwareRevision');
    str = strcat ('InstrumentFirmwareRevision= ',propertyValue);  
    disp(str);
    propertyValue = get(comobj, 'Description');
    str = strcat ('Description= ',propertyValue);  
    disp(str);
    propertyValue = get(comobj, 'Identifier');
    str = strcat ('Identifier= ',propertyValue);  
    disp(str);
    propertyValue = get(comobj, 'Vendor');
    str = strcat ('Vendor= ',propertyValue);  
    disp(str);
    propertyValue = get(comobj, 'Revision');
    str = strcat ('Revision= ',propertyValue);  
    disp(str);
    
    %% Write a byte to the digital output port
    groupObj = get(deviceObj, 'Digitalout');
    groupObj = groupObj(1);
    invoke(groupObj, 'WriteByte', 5);
    
    % Confirm the value written to digital output port by reading back the
    % port
     ByteWritten = invoke(groupObj, 'ReadByte');
    
    
catch DT8824error
    disp(['Error id: ', DT8824error.identifier]);
    disp(['Error Message: ',DT8824error.message]);
end

% Disconnect the device object from the instrument and remove it from memory
disconnect(deviceObj);
delete(deviceObj);   

